#!/usr/bin/perl
# This package defines the class object
# for object oriented programming ...
use strict;

package Debug;

  our (@ISA, @EXPORT);
  require Exporter;
  @ISA = qw(Exporter);
  @EXPORT = qw(debug debugging);
  
  my $_DebugLevel = 0;
  my $_DebugFile  = "";

  sub debugging {
    my $OldLevel = $_DebugLevel;
    my $OldFile  = $_DebugFile;
    my $class = shift;
    if ($class eq __PACKAGE__) {
      unless (@_ <= 2) {warn "usage: CLASSNAME->debug(level[, <filename>])"}
      $_DebugLevel = shift;
    } else {
      unless (@_ <= 1) {warn "usage: CLASSNAME->debug(level[, <filename>])"}
      $_DebugLevel = $class
    }
    if (@_) {$_DebugFile = shift}

    if (($_DebugLevel == 0) || ($_DebugFile ne $OldFile)) {
      close OUTFILE;
    }
    if (($_DebugLevel > 0) && (($OldLevel == 0) || ($_DebugFile ne $OldFile))) {
      if ($_DebugFile ne "") {
        open (OUTFILE, '>', $_DebugFile)
          or die "Cannot open the debugfile $_DebugFile!\n\n";
      }
    }
  }
  
  sub debug {
    my $text = shift;
    my $debuglevel = 1;

    if ($text eq __PACKAGE__) { $text = shift }

    # a debuglevel can be added if necessary, level 1 is default   
    if (@_) {$debuglevel = shift}

    
    if ($_DebugLevel >= $debuglevel) {
      if ($_DebugFile eq "") {
        print STDOUT $text;
      } else {
        print OUTFILE $text;
      }
    }
  }
1;
