package Constants;

use strict;
require Exporter;

# Define constants ...
our %HTMLTable;             # Definition of the tables and they type of objects in it

# CheckPoint coding
our %MethodHTTP;			# Coding of the resource methods for HTTP
our %MethodFTP;				# Coding of the resource methods for FTP
our %Scheme;				# Coding of the resource schemes
our %Month;					# Defines the name of the months
our %Day;					# Defines the names and value of the days
our %Position;				# Defines the position within the rulebase
our %Track;					# Defines the tracking option (none, log, alert)
our %ExceptionTrack;		# Defines the exception tracking option (none, log, alert)
our %SYNTrack;				# Defines the SYN Attack logging levels
our %IntDirect;				# Defines the interface direction
our %IKEDoS;				# Defines the values for the IKE DoS protection
our %EarlySCV;				# Defines policy for Early versions of SecureClient
our %UnitsMeasure;			# Defines the units of measure
our %UFPCaching;			# Defines the UPF Caching options
our %AuthScheme;			# Defines the authentication methods available
our %AuthCode;				# Defines the authentication methods available in a gateway (binary)
our %MacCalc;				# Defines how mac addresses will be assigned in office mode
our %VPNAsk;                # Defines the choices for Clientless VPN client certificates
our %LogLevel;				# Defines the logging for UserAuthority
our %DiskSpace;				# Defines the diskpace numbers
our %WebURLAction;			# UA_WebAccess - actions taken for URL outside the scope of the policy
our %SSLredirect;			# UA_WebAccess - SSL redirection methodology
our %APN_selmode;			# GTP Advanced - selection mode
our %CPcolors; 				# Coding of Check Point colors
our %Subnet;				# Coding of CIDR subnets

# Define max length for comment field
our $_MAX_COMMENT_LENGTH = 30;	# Comment field length delimiter

# Define flags for object options ...
our $_NAT  = 1;		# Flag: Object is used in Automatic NAT rule
our $_NEG  = 2;		# Flag: Negate object
our $_HREF = 4;		# Flag: Include reference to object
our $_NAT_HIDE   =  8;	# Flag: Object is used in Hide NAT rule
our $_NAT_STATIC = 16;	# Flag: Object is used in Static NAT rule

# Define constants for Section constants ...
our $_SKIP   = 0;	# Constant: do not show section
our $_CLOSED = 1;	# Constant: do show section folded
our $_OPEN   = 2;	# Constant: do show section unfolded

our (@ISA, @EXPORT);
@ISA = qw(Exporter);
@EXPORT = qw(	%HTMLTable %MethodHTTP %MethodFTP
				%Scheme %Month %Day %Position %Track %ExceptionTrack %SYNTrack %IntDirect %IKEDoS
				%EarlySCV %UnitsMeasure %UFPCaching %AuthScheme %AuthCode %MacCalc %VPNAsk
				%LogLevel %DiskSpace %WebURLAction %SSLredirect %APN_selmode
				%CPcolors %Subnet
				$_MAX_COMMENT_LENGTH
				$_NAT $_NEG	$_HREF 
				$_NAT_HIDE $_NAT_STATIC
				$_SKIP $_CLOSED $_OPEN
			);


# %HTMLTable defines how the html tables are build. 
# The structure per table is defined as follows:
# <Table Name> (f.i. GATEWAYS) allways in capitals
#		TABLE => <Check Point table name> (f.i. 'network_objects')
#		TYPE  => Hash van <Check Point types> (f.i. 'gateway') ALWAYS 
#			     use small letters. CAPS are not allowed!!!
#
#			If the type definition is not specific enough, one can
#			create a hash for the type to specify further on. This
#			can be seen in the GATEWAYS section where the parameter 
#			'AdminInfo:ClassName' (see objects_5_0.C) is used to 
#			specify different type of gateways...
#    ... or ...
#		LIST  => In rulebase-cases the objects to display are stored
#			in an array, not a hash (they all have the same name...).
#			This keyword can be used to show that.
%HTMLTable = (
		SECURITY => {
			TABLE => 'rule-base',
			LIST  => 'rule'
		},
		NAT => {
			TABLE => 'rule-base',
			LIST  => 'rule_adtr'
		},
		DESKTOP => {
			TABLE => 'slp-rule-base',
			LIST  => 'rule'
		},
		CHECKPOINT =>	{
			TABLE => 'network_objects',
			CLASS => {
				'gateway_ckp' => {
					'location'	=> {
						'internal'			=> '1:Gateway',
						'external'			=> '9:Externally Managed Gateway'
					}
				},
				'sofaware_gateway'          => '2:VPN-1 Edge/Embedded Gateway',
				'host_ckp' 					=> '3:Check Point Host',
				'gateway_cluster'			=> '4:Gateway Cluster',
				'cluster_member'			=> '5:Cluster Member',
				'embedded_device'			=> '6:Embedded Device',
				'sofaware_gateway_profile'	=> '8:VPN-1 Edge/Embedded Profile',
			}
		},
		INTEROPERABLE => {
			TABLE => 'network_objects',
			CLASS => {
				'gateway_plain' => {
					'VPN:AdminInfo:ClassName' 	=> { 'vpn' => '1:Interoperable Device' }
				}
			}
		},
		NODES => {
			TABLE => 'network_objects',
			CLASS => {
				'host_plain'	=> '1:Host Node',
				'gateway_plain' => {
					'VPN' 						=> { ''	   => '2:Gateway Node' }
				}
			}
		},
		NETWORKS =>	{
			TABLE => 'network_objects',
			CLASS => {
				'network'	=> '1:Network'
			}
		},
		DOMAINS => {
			TABLE => 'network_objects',
			CLASS => {
				'domain'	=> '1:Domain'
			}
		},
		ACCESSPOINTS => {
			TABLE => 'network_objects',
			CLASS => {
				'gprs_apn'	=> '1:Access Point Name'
			}
		},
		OSEDEVICES => {
			TABLE => 'network_objects',
			CLASS => {
				'ose_device' => {
					'vendor' => {
						'3com'		   => '1:3Com Router',
						'cisco'        => '2:Cisco Router',
						'bay networks' => '3:Nortel Router'
					}
				}
			}
		},
		OBJECTGROUPS =>	{
			TABLE => 'network_objects',
			CLASS => {
				'network_object_group'	=> '1:Simple Group',
				'group_with_exception'	=> '2:Group with Exclusion',
				'uas_collection'		=> '3:User Authority Server Group',
				'gsn_handover_group'    => '4:GSN Handover Group'
			}
		},
		LOGICALSERVERS => {
			TABLE => 'network_objects',
			CLASS => {
				'logical_server'	=> '1:Logical Server'
			}
		},
		ADDRESSRANGES => {
			TABLE => 'network_objects',
			CLASS => {
				'address_range'		=> '1:Address Range'
			}
		},
		DYNAMICOBJECTS => {
			TABLE => 'network_objects',
			CLASS => {
				'dynamic_object'	=> '1:Dynamic Object'
			}
		},
		VOIPDOMAINS => {
			TABLE => 'network_objects',
			CLASS => {
				'voip_SIP_domain'	=> '1:VoIP Domain SIP',
				'voip_GK_domain'	=> '2:VoIP Domain H.323 Gatekeeper',
				'voip_GW_domain'	=> '3:VoIP Domain H.323 Gateway'
			}
		},
		SERVICES => {
			TABLE => 'services',
			CLASS => {
				'tcp_service' 			=> '1:TCP',
				'compound_tcp_service'	=> '2:Compound TCP',
				'tcp_citrix_service' 	=> '3:Citrix TCP',
				'udp_service'			=> '4:UDP',
				'rpc_service' 			=> '5:RPC',
				'icmp_service' 			=> '6:ICMP',
				'other_service' 		=> '7:Other',
				'dcerpc_service' 		=> '8:DCE-RPC',
				'gtp_service' 			=> '9:GTP',
				'gtp_v1_service'		=> '9:GTP'
			}
		},
		SERVICEGROUPS => {
			TABLE => 'services',
			CLASS => {
				'service_group'	=> '1:Service Group'
			}
		},
		RESOURCES => {
			TABLE => 'resources',
			CLASS => {
				'uri_resource'		=> '1:URI',
				'etm-uri_resource'	=> '2:URI for QoS',
				'smtp_resource'		=> '3:SMTP',
				'ftp_resource'		=> '4:FTP',
				'tcp_resource'		=> '5:TCP',
				'cifs_resource'		=> '6:CIFS'
			}
		},
		SERVERS => {
			TABLE => 'servers',
			CLASS => {
				'radius_server' 		=> '1:RADIUS',
				'radius_group' 			=> '2:RADIUS Group',
				'tacacs_server' 		=> '3:TACACS',
				'ldap_account_unit' 	=> '4:LDAP Account Unit',
				'internal_ca_server'	=> '5:Certificate Authority',
				'secuRemote_dns_server'	=> '6:SecuRemote DNS'
			}
		},
		OPSEC => {
			TABLE => 'opsec',
			CLASS => {
				'opsec_application'	=> '1:OPSEC Application',
				'cvp_collection'	=> '2:CVP Group',
				'ufp_collection'	=> '3:UFP Group',
				'cpmi_collection'	=> '4:CPMI Group'
			}
		},
		TIMES => {
			TABLE => 'times',
			CLASS => {
				'time'				=> '1:Time',
				'scheduled_event'	=> '2:Scheduled Event',
				'time_group'		=> '3:Time Group'
			}
		},
		COMMUNITIES	=> {
			TABLE => 'communities',
			CLASS => {
				'intranet_community'	=> {
					'topology' => {
						'meshed'		=> '1:Site to Site - Meshed',
						'star'			=> '2:Site to Site - Star'
					}
				},
				'sr_community'			=>	'3:Remote Access',
				'extranet_community'	=>	'4:Extranet Manager',
				'extranet_partner'		=>	'5:Extranet Partner'
			}
		},
		USERS => {
			TABLE => 'users',
			CLASS => {
				'user' => {
					'administrator' => {
						'true'  => '1:Administrator',
						'false' => '2:User'
					}
				}
			}
		},
		USERGROUPS => {
			TABLE => 'users',
			CLASS => {
				'administrator_group' => '1:Administrator Group',
				'user_group'          => '2:User Group'
			}
		}
);


# %MethodHTTP defines the possible methods in 
# a URI resource
%MethodHTTP = (
		get		=> 1,
		post	=> 2,
		head	=> 4,
		put		=> 8
	);
	
# %MethodFTP defines the possible methods in 
# a FTP resource
%MethodFTP = (
		GET		=> 1,
		PUT		=> 2
	);
	
# %Scheme defines the possible schemes used 
# in a general resource
%Scheme = (
		http	=> 1,
		ftp		=> 2,
		gopher	=> 4,
		mailto	=> 8,
		news	=> 16,
		wais	=> 32
	);

# %Month defines the full names of the months
%Month = (
		Jan => 'Januari',
		Feb => 'Februari',
		Mar => 'March',
		Apr => 'April',
		May => 'May',
		Jun => 'June',
		Jul => 'July',
		Aug => 'August',
		Sep => 'September',
		Oct => 'October',
		Nov => 'November',
		Dec => 'December'
	);

# %Day defines the names and value of the days
%Day = (
		Monday 	  => 1,
		Tuesday   => 2,
		Wednesday => 4,
		Thursday  => 8,
		Friday 	  => 16,
		Saturday  => 32,
		Sunday    => 64
	);
	
# %Position defines the location in the rulebase
%Position = (
		"first"			=> 'First',
		"before last"	=> 'Before Last',
		"last"			=> 'Last'
	);

# %Track defines the tracking options
%Track = (
		none		=> 'None',
		log			=> 'Log',
		alert		=> 'Popup Alert',
		mail		=> 'Mail Alert',
		snmptrap	=> 'SNMP Trap Alert',
		useralert	=> 'User Defined Alert no.1',
		useralert2	=> 'User Defined Alert no.2',
		useralert3	=> 'User Defined Alert no.3'
	);

# %ExceptionTrack defines the exception tracking options
%ExceptionTrack = (
		None				=> 'None',
		"Exception Log"		=> 'Log',
		"Exception Alert"	=> 'Alert'
	);

# %SYNTrack defines the SYN Attack logging levels
%SYNTrack = (
	0	=> 'None',
	1	=> 'Attacks only',
	2	=> "Individual SYN's"
);
	
# %IntDirect defines the interface direction
%IntDirect = (
		inbound		=> 'Inbound',
		outbound	=> 'Outbound',
		eitherbound	=> 'Eitherbound'
	);
	
# %IKEDos defines IKE DoS protection values
%IKEDoS = (
		none		=> 'None',
		stateless	=> 'Stateless',
		puzzles		=> 'Puzzles'
	);

# %EarlySCV defines policy for Early versions of SecureClient
%EarlySCV = (
		0	=> 'No Policy',
		1	=> 'Allow Outgoing & Encrypted',
		2	=> 'Allow Outgoing Only',
		3	=> 'Allow Encrypted Only'
	);

# %UnitsMeasure defines the units of measure
%UnitsMeasure = (
		bps		=> 'bps - bits / sec',
		Bps		=> 'Bps - Bytes /sec',
		Kbps	=> 'Kbps - Kbits / sec',
		KBps	=> 'KBps - Kbytes / sec',
		Mbps	=> 'Mbps - Mbits /sec',
		MBps	=> 'MBps - Mbytes / sec'
	);

# %UFPCaching defines the UFP Caching options
%UFPCaching = (
		none		=> 'No caching',
		server		=> 'UFP server',
		client 		=> 'VPN-1 & FireWall-1 (one request)',
		client2nd	=> 'VPN-1 & FireWall-1 (two requests)'
	);

# %AuthScheme defines the authentication methods available
%AuthScheme = (
		Undefined			=> 'Undefined',
		SecurID				=> 'SecurID',
		"Internal Password"	=> 'Internal Password',
		"Unix Password"		=> 'Unix Password',
		radius				=> 'RADIUS',
		tacacs				=> 'TACACS'
	);

# %AuthCode defines the possible schemes used 
# in the authentication tab of a gateway
%AuthCode = (
		'SecurID'	=> 2,
		'OS'		=> 4,
		'VPN-1'		=> 8,
		'RADIUS'	=> 16,
		'TACACS'	=> 64
	);
			
# Defines how mac addresses will be assigned in office mode
%MacCalc = (
	user    => 'Calculated per user name',
	machine => 'Unique per machine'
);

# Defines the choices for Clientless VPN client certificates
%VPNAsk = (
	none	=> 'Do not ask the client to present a certificate',
	ask     => 'Ask the client to present a certificate',
	require	=> 'Require the client to present a certificate'
);

# Defines the logging for UserAuthority
%LogLevel = (
	low    => 'Low',
	medium => 'Medium',
	high   => 'High'
);

# Defines the diskpace numbers
%DiskSpace = (
	mbytes  => 'MBytes',
	percent => 'Percent'
);

# UA_WebAccess - actions taken for URL outside the scope of the policy
%WebURLAction = (
	accept	=> 'Accept',
	reject	=> 'Reject',
	redirect=> 'Redirect'
);

# UA_WebAccess - SSL redirection methodology
%SSLredirect = (
	redirect_to_page => 'Redirect to page',
	redirect_to_original_url_by_https => 'Redirect to original URL by HTTPS'
);

# APN_selmode - GTP Advanced selection mode
%APN_selmode = (
	0	=> '0 - verified',
	1	=> '1 - MS - not verified',
	2	=> '2 - Network - not verified'
);
# Define colors used by Check Point ...
%CPcolors =
  ( # NG colors included, now 36 colors
   'aquamarine1'    => '#7BFFD6',
   'black'		    => '#000000',
   'blue'           => '#0000FF',
   'blue1'          => '#4241EF',
   'burlywood4'     => '#8C7152',
   'cyan'           => '#00FFFF',
   'dark green'     => '#848200',
   'dark khaki'     => '#BDB66B',
   'dark orchid'    => '#840084',
   'darkorange3'    => '#CE6500',
   'darkseagreen3'  => '#9CCF9C',
   'deep pink'      => '#FF1494',
   'deepskyblue1'   => '#00BEFF',
   'dodgerblue3'    => '#1875CE',
   'firebrick'      => '#B52021',
   'foreground'     => '#000000',
   'forest green'   => '#218A21',
   'gold'           => '#FFD700',
   'gold3'          => '#CEAE00',
   'gray83'         => '#D6D7D6',
   'gray90'         => '#ADB2C6',
   'green'          => '#00FF00',
   'lemonchiffon'   => '#FFFBCE',
   'light coral'    => '#F78284',
   'lightseagreen'  => '#21B2AD',
   'lightskyblue4'  => '#63798C',
   'magenta'        => '#FF00FF',
   'medium orchid'  => '#BD55D6',
   'medium slate blue'  => '#7B69EF',
   'medium violet red'  => '#C61484',
   'navy blue'      => '#000084',
   'olive drab'     => '#6B8E21',
   'orange'         => '#FFA600',
   'red'            => '#FF0000',
   'sienna'         => '#A55129',
   'yellow'         => '#FFFF00'
   );

# Conversion table to convert subnet mask to CIDR notation ...
%Subnet = (
	'255.255.255.255'	=> '32',
	'255.255.255.254'	=> '31',
	'255.255.255.252'	=> '30',
	'255.255.255.248'	=> '29',
	'255.255.255.240'	=> '28',
	'255.255.255.224'	=> '27',
	'255.255.255.192'	=> '26',
	'255.255.255.128'	=> '25',
	'255.255.255.0'		=> '24',
	'255.255.254.0'		=> '23',
	'255.255.252.0'		=> '22',
	'255.255.248.0'		=> '21',
	'255.255.240.0'		=> '20',
	'255.255.224.0'		=> '19',
	'255.255.192.0'		=> '18',
	'255.255.128.0'		=> '17',
	'255.255.0.0'		=> '16',
	'255.254.0.0'		=> '15',
	'255.252.0.0'		=> '14',
	'255.248.0.0'		=> '13',
	'255.240.0.0'		=> '12',
	'255.224.0.0'		=> '11',
	'255.192.0.0'		=> '10',
	'255.128.0.0'		=> '9',
	'255.0.0.0'			=> '8',
	'254.0.0.0'			=> '7',
	'252.0.0.0'			=> '6',
	'248.0.0.0'			=> '5',
	'240.0.0.0'			=> '4',
	'224.0.0.0'			=> '3',
	'192.0.0.0'			=> '2',
	'128.0.0.0'			=> '1',
	'0.0.0.0'			=> '0'
	);

1;