#!/usr/bin/perl
# This package defines the class CPobject
# for object oriented programming ...

package CPobject;
  use strict;
  use Debug;
  
  our (@ISA, @EXPORT);
  require Exporter;
  @ISA = qw(Exporter, Debug);
  @EXPORT = qw();
 
  sub new {
    # Create a new object
    my ($class, $hash);
    $class = shift;
    $class = ref($class) || $class;

    $hash  = {};
    bless ($hash, $class);
    &debug("*NEW ".$hash."\n", 9);
    return $hash;
  }
  
  sub DESTROY {
    my $hash = shift;
    &debug("*DESTROY ".$hash."\n", 9);
  }
  
  sub set {
    # Set a value within the object
    my $hash = shift;
    my $key  = shift;
    if (@_) {$hash->{$key} = shift}
    &debug("*SET $hash:$key = ".$hash->{$key}."\n", 9);
    return $hash->{$key};
  }
  
1;