package Strings;

use strict;
use warnings;

our (@ISA, @EXPORT);

require Exporter;
@ISA = qw(Exporter);
@EXPORT = qw(strip stripquotes html fromdos text2html);

##########################################################################
# Strip whitespaces of string
sub strip {
	my $string = shift;
	if ($string) {
		$string =~ s/^\s+//;
		$string =~ s/\s+$//;
	}
	return $string;
}

##########################################################################
# Remove surrounding double-quotes of string
# - if no quotes are found, original string is returned
# - whitespaces before or after the quotes are removed
# - whitespaced insided the quotes are reserved
sub stripquotes {
	my $string = shift;
	if ($string) {
		if ($string =~ /^\s*"(.*)"\s*$/) {
			# remove surrounding spaces
			$string = strip($string);
			$string =~ s/^"//;
			$string =~ s/"$//;
		}
	}
	return $string;
}

##########################################################################
# Remove end-of-line characters 
sub fromdos {
	my $line = $_[0];
	if ($line) {
		$line =~ s/\n//g;
		$line =~ s/\r//g;
		$line =~ s/        /\t/g;
	}
	return $line;
}

##########################################################################
# Convert special characters to be displayed in HTML
#
# Note:  CheckPoint uses ';' for a line break ....
sub html {
    my $string = shift;
	if ($string) {
		$string =~ s/&/&amp/g;
		$string =~ s/</&lt/g;
		$string =~ s/>/&gt/g;
    	# with the introduction of version 1.03, the <NOBR>...</NOBR> sequences
    	# are used to prevent line breaking, making the below translations unneccessary.
    	#$string =~ s/ /&nbsp;/g;
    	#$string =~ s/-/&#8209;/g;

		# CheckPoint uses ';' for a line break ....
    	$string =~ s/;/<BR>/g;
    }
    return $string;
}


##########################################################################
# Split line in line of (max) length lines 
#   and convert those to html code
sub text2html {
	my $text   = shift;
	my $length = shift;
	if (!$length) { $length = 10000 }
	
	my @lines = ();
	my $line  = '';
	my @words = split(/ /, $text);
	my $word  = '';
		
	if (length($text)>$length) {
		# Comment too long for one line ...
		# Break into separate lines
		foreach $word (@words) {
			if (length($line.' '.$word)<=$length) {
				$line .= ' '.$word
			} else {
				if ($line eq '') { 
					# single $word is longer as $CommentLength ...
					push @lines, html($word);
				} else {
					push @lines, html(strip($line));
					$line = $word;
				}
			}
		}
		if ($line ne '') { push @lines, html(strip($line)) }
	} else {
		push @lines, html($text);
	}

	if (!$lines[0]) { 
		$text = '&nbsp;'
	} else {
		$text = join('<BR>', @lines);	
	}

	return $text;
}
