package Constants;

use strict;
require Exporter;

# Define constants ...
our %Table;					# Definition of the tables and their setup
# CheckPoint coding
our %MethodHTTP;			# Coding of the resource methods for HTTP
our %MethodFTP;				# Coding of the resource methods for FTP
our %Scheme;				# Coding of the resource schemes
our %Month;					# Defines the name of the months
our %Position;				# Defines the position within the rulebase
our %Track;					# Defines the tracking option (none, log, alert)
our %IKEDoS;				# Defines the values for the IKE DoS protection
our %EarlySCV;				# Defines policy for Early versions of SecureClient
our %UnitsMeasure;			# Defines the units of measure
our %CPcolors; 				# Coding of Check Point colors
our %Subnet;				# Coding of CIDR subnets
# Other Constants
our $_MAX_COMMENT_LENGTH;	# Comment field length delimiter
# Flags
our $_NAT;					# Flag: Object is used in Automatic NAT rule
our	$_NEG;					# Flag: Negate object
our	$_HREF;					# Flag: Include reference to object
our	$_NAT_HIDE;				# Flag: Object is used in Hide NAT rule
our	$_NAT_STATIC;			# Flag: Object is used in Static NAT rule

our (@ISA, @EXPORT);
@ISA = qw(Exporter);
@EXPORT = qw(	%Table %MethodHTTP %MethodFTP
				%Scheme %Month %Position %Track %IKEDoS %EarlySCV 
				%UnitsMeasure %CPcolors %Subnet
				$_MAX_COMMENT_LENGTH
				$_NAT $_NEG	$_HREF 
				$_NAT_HIDE $_NAT_STATIC
			);

# Define max length for comment field
$_MAX_COMMENT_LENGTH = 30;

# Define flags for object options ...
$_NAT  = 1;		# Automatic NAT rule
$_NEG  = 2;		# Object should be negated
$_HREF = 4;		# Object should have a reference tag

$_NAT_HIDE   = 8;	# Object is Hide NAT
$_NAT_STATIC = 16;	# Object is Static NAT


# %Table defines how the html tables are build. 
# The structure per table is defined as follows:
# <Table Name> (f.i. GATEWAYS) allways in capitals
#		TABLE => <Check Point table name> (f.i. 'network_objects')
#		TYPE  => Hash van <Check Point types> (f.i. 'gateway') ALWAYS 
#			     use small letters. CAPS are not allowed!!!
#
#			If the type definition is not specific enough, one can
#			create a hash for the type to specify further on. This
#			can be seen in the GATEWAYS section where the parameter 
#			'AdminInfo:ClassName' (see objects_5_0.C) is used to 
#			specify different type of gateways...
#    ... or ...
#		LIST  => In rulebase-cases the objects to display are stored
#			in an array, not a hash (they all have the same name...).
#			This keyword can be used to show that.
%Table = (
		RULES => {
			TABLE => 'rule-base',
			LIST  => 'rule'
		},
		NATRULES => {
			TABLE => 'rule-base',
			LIST  => 'rule_adtr'
		},
		CHECKPOINT =>	{
			TABLE => 'network_objects',
			TYPE  => {
				'host'      => {
					'AdminInfo:ClassName' => {
						'host_ckp'          => '1:Check Point Host'
					}
				},
				'gateway'	=> {
					'AdminInfo:ClassName' => {
						'gateway_ckp'		        => '2:Gateway',
						'sofaware_gateway_profile'	=> '7:Gateway Profile'
					}
				},
				'gateway_cluster'			=> '3:Gateway Cluster',
				'cluster_member'			=> '4:Cluster Member',
				'sofaware_gateway'          => '5:VPN-1 Edge/Embedded Gateway',
				'sofaware_gateway_profile'	=> '6:Sofaware Profile',
			}
		},
		NODES => {
			TABLE => 'network_objects',
			TYPE  => {
				'gateway'	=> {
					'AdminInfo:ClassName' => {
						'gateway_plain'		=> '1:Gateway Node',
					}
				},
				'host'	=> '2:Host Node'
			}
		},
		NETWORKS =>	{
			TABLE => 'network_objects',
			TYPE  => {
				'network'	=> '1:Network'
			}
		},
		DOMAINS => {
			TABLE => 'network_objects',
			TYPE  => {
				'domain'	=> '1:Domain'
			}
		},
		ACCESSPOINTS => {
			TABLE => 'network_objects',
			TYPE  => {
				'gprs_apn'	=> '1:Access Point Name'
			}
		},
		OSEDEVICES => {
			TABLE => 'network_objects',
			TYPE  => {
				'router'	=> {
					'vendor' => {
						'3com'		   => '1:3Com Router',
						'cisco'        => '2:Cisco Router',
						'bay networks' => '3:Nortel Router'
					}
				}
			}
		},
		OBJECTGROUPS =>	{
			TABLE => 'network_objects',
			TYPE  => {
				'group'					=> '1:Simple Group',
				'group_with_exclusion'	=> '2:Group with Exclusion',
				'uas_collection'		=> '3:User Authority Server Group',
				'gsn_handover_group'    => '4:GSN Handover Group'
			}
		},
		LOGICALSERVERS => {
			TABLE => 'network_objects',
			TYPE  => {
				'logical'	=> '1:Logical Server'
			}
		},
		ADDRESSRANGES => {
			TABLE => 'network_objects',
			TYPE  => {
				'machines_range'	=> '1:Address Range'
			}
		},
		DYNAMICOBJECTS => {
			TABLE => 'network_objects',
			TYPE  => {
				'dynamic_net_obj'	=> '1:Dynamic Object'
			}
		},
		VOIPDOMAINS => {
			TABLE => 'network_objects',
			TYPE  => {
				'voip_sip'	=> '1:VoIP Domain SIP',
				'voip_gk'	=> '2:VoIP Domain H.323 Gatekeeper',
				'voip_gw'	=> '3:VoIP Domain H.323 Gateway'
			}
		},
		SERVICES => {
			TABLE => 'services',
			TYPE  => {
				'tcp' 				=> '1:TCP',
				'tcp_subservice'	=> '2:Compound TCP',
				'tcp_citrix' 		=> '3:Citrix TCP',
				'udp'				=> '4:UDP',
				'rpc' 				=> '5:RPC',
				'icmp' 				=> '6:ICMP',
				'other' 			=> '7:Other',
				'dcerpc' 			=> '8:DCE-RPC',
				'gtp' 				=> '9:GTP'
			}
		},
		SERVICEGROUPS => {
			TABLE => 'services',
			TYPE  => {
				'group'	=> 'A:Group'
			}
		},
		RESOURCES => {
			TABLE => 'resources',
			TYPE => {
				'uri'			=> '1:URI',
				'etm-uri'		=> '2:URI for QoS',
				'smtp'			=> '3:SMTP',
				'ftp'			=> '4:FTP',
				'tcp_resource'	=> '5:TCP',
				'cifs'			=> '6:CIFS'
			}
		},
		SERVERS => {
			TABLE => 'servers',
			TYPE  => {
				'radius' 		=> '1:RADIUS',
				'group' 		=> '2:RADIUS Group',
				'tacacs' 		=> '3:TACACS',
				'ldap_au' 		=> '4:LDAP Account Unit',
				'ca'			=> '5:Certificate Authority',
				'sr_dns_server'	=> '6:SecuRemote DNS'
			}
		},
		OPSEC => {
			TABLE => 'opsec',
			TYPE  => {
				'opsec_application'	=> '1:OPSEC Application',
				'cvp_collection'	=> '2:CVP Group',
				'ufp_collection'	=> '3:UFP Group',
				'cpmi_collection'	=> '4:CPMI Group'
			}
		},
		TIMES => {
			TABLE => 'times',
			TYPE  => {
				'time'				=> '1:Time',
				'group'				=> '2:Group',
				'scheduled_event'	=> '3:Scheduled Event'
			}
		},
		COMMUNITIES	=> {
			TABLE => 'communities',
			TYPE  => {
				'intranet_community'	=> {
					'topology' => {
						'meshed'		=> '1:Site to Site - Meshed',
						'star'			=> '2:Site to Site - Star'
					}
				},
				'sr_community'			=>	'3:Remote Access',
				'extranet_community'	=>	'4:Extranet Manager',
				'extranet_partner'		=>	'5:Extranet Partner'
			}
		},
		USERS => {
			TABLE => 'users',
			TYPE  => {
				'user'	=> '1:User'
			}
		},
		USERGROUPS => {
			TABLE => 'users',
			TYPE  => {
				'usergrp'	=> '1:UserGroup'
			}
		}
);


# %MethodHTTP defines the possible methods in 
# a URI resource
%MethodHTTP = (
		get		=> 1,
		post	=> 2,
		head	=> 4,
		put		=> 8
	);
	
# %MethodFTP defines the possible methods in 
# a FTP resource
%MethodFTP = (
		GET		=> 1,
		PUT		=> 2
	);
	
# %Scheme defines the possible schemes used 
# in a general resource
%Scheme = (
		http	=> 1,
		ftp		=> 2,
		gopher	=> 4,
		mailto	=> 8,
		news	=> 16,
		wais	=> 32
	);

# %Month defines the full names of the months
%Month = (
		Jan => 'Januari',
		Feb => 'Februari',
		Mar => 'March',
		Apr => 'April',
		May => 'May',
		Jun => 'June',
		Jul => 'July',
		Aug => 'August',
		Sep => 'September',
		Oct => 'October',
		Nov => 'November',
		Dec => 'December'
	);

# %Position defines the location in the rulebase
%Position = (
		"first"			=> 'First',
		"before last"	=> 'Before Last',
		"last"			=> 'Last'
	);

# %Track defines the tracking options
%Track = (
		none		=> 'None',
		log			=> 'Log',
		alert		=> 'Popup Alert',
		mail		=> 'Mail Alert',
		snmptrap	=> 'SNMP Trap Alert',
		useralert	=> 'User Defined Alert no.1',
		useralert2	=> 'User Defined Alert no.2',
		useralert3	=> 'User Defined Alert no.3'
	);
	
# %IKEDos defines IKE DoS protection values
%IKEDoS = (
		none		=> 'None',
		stateless	=> 'Stateless',
		puzzles		=> 'Puzzles'
	);

# %EarlySCV defines policy for Early versions of SecureClient
%EarlySCV = (
		0	=> 'No Policy',
		1	=> 'Allow Outgoing & Encrypted',
		2	=> 'Allow Outgoing Only',
		3	=> 'Allow Encrypted Only'
	);

# %UnitsMeasure defines the units of measure
%UnitsMeasure = (
		bps		=> 'bps - bits / sec',
		Bps		=> 'Bps - Bytes /sec',
		Kbps	=> 'Kbps - Kbits / sec',
		KBps	=> 'KBps - Kbytes / sec',
		Mbps	=> 'Mbps - Mbits /sec',
		MBps	=> 'MBps - Mbytes / sec'
	);
			
# Define colors used by Check Point ...
%CPcolors =
  ( # NG colors included, now 36 colors
   'aquamarine1'    => '#7BFFD6',
   'black'		    => '#000000',
   'blue'           => '#0000FF',
   'blue1'          => '#4241EF',
   'burlywood4'     => '#8C7152',
   'cyan'           => '#00FFFF',
   'dark green'     => '#848200',
   'dark khaki'     => '#BDB66B',
   'dark orchid'    => '#840084',
   'darkorange3'    => '#CE6500',
   'darkseagreen3'  => '#9CCF9C',
   'deep pink'      => '#FF1494',
   'deepskyblue1'   => '#00BEFF',
   'dodgerblue3'    => '#1875CE',
   'firebrick'      => '#B52021',
   'foreground'     => '#000000',
   'forest green'   => '#218A21',
   'gold'           => '#FFD700',
   'gold3'          => '#CEAE00',
   'gray83'         => '#D6D7D6',
   'gray90'         => '#ADB2C6',
   'green'          => '#00FF00',
   'lemonchiffon'   => '#FFFBCE',
   'light coral'    => '#F78284',
   'lightseagreen'  => '#21B2AD',
   'lightskyblue4'  => '#63798C',
   'magenta'        => '#FF00FF',
   'medium orchid'  => '#BD55D6',
   'medium slate blue'  => '#7B69EF',
   'medium violet red'  => '#C61484',
   'navy blue'      => '#000084',
   'olive drab'     => '#6B8E21',
   'orange'         => '#FFA600',
   'red'            => '#FF0000',
   'sienna'         => '#A55129',
   'yellow'         => '#FFFF00'
   );

# Conversion table to convert subnet mask to CIDR notation ...
%Subnet = (
	'255.255.255.255'	=> '32',
	'255.255.255.254'	=> '31',
	'255.255.255.252'	=> '30',
	'255.255.255.248'	=> '29',
	'255.255.255.240'	=> '28',
	'255.255.255.224'	=> '27',
	'255.255.255.192'	=> '26',
	'255.255.255.128'	=> '25',
	'255.255.255.0'		=> '24',
	'255.255.254.0'		=> '23',
	'255.255.252.0'		=> '22',
	'255.255.248.0'		=> '21',
	'255.255.240.0'		=> '20',
	'255.255.224.0'		=> '19',
	'255.255.192.0'		=> '18',
	'255.255.128.0'		=> '17',
	'255.255.0.0'		=> '16',
	'255.254.0.0'		=> '15',
	'255.252.0.0'		=> '14',
	'255.248.0.0'		=> '13',
	'255.240.0.0'		=> '12',
	'255.224.0.0'		=> '11',
	'255.192.0.0'		=> '10',
	'255.128.0.0'		=> '9',
	'255.0.0.0'			=> '8',
	'254.0.0.0'			=> '7',
	'252.0.0.0'			=> '6',
	'248.0.0.0'			=> '5',
	'240.0.0.0'			=> '4',
	'224.0.0.0'			=> '3',
	'192.0.0.0'			=> '2',
	'128.0.0.0'			=> '1',
	'0.0.0.0'			=> '0'
	);

1;