// ---------------------------------------------
// Script library: visible.js                   
// ---------------------------------------------
// Scripts to toggle visibility of sections     
// ---------------------------------------------
// Functions                                    
//   OpenSection(section)                       
//   - makes section visible                    
//   CloseSection(section)                       
//   - closes section                            
//   ToggleSection(section)                     
//   - makes section visible if hidden and vv   
//                                              
//   CloseAllSections(type, name)                
//   - Closes all sections of type 'type'matching
//     the regular expression name               
//   OpenAllSections(type, name)                
//   - Shows all sections of type 'type'matching
//     the regular expression name               
// ---------------------------------------------

function getObj(name) { 
	if (document.getElementById) { 
		this.obj = document.getElementById(name) 
		this.style = document.getElementById(name).style 
	} else if (document.all) { 
		this.obj = document.all[name] 
		this.style = document.all[name].style 
	} else if (document.layers) { 
		this.obj = document.layers[name] 
		this.style = document.layers[name] 
	} 
} 

function OpenSection(section) {
	var obj = new getObj(section);
	obj.style.display="";
}
  
function CloseSection(section) {
	var obj = new getObj(section);
	obj.style.display="none";
}

function ToggleSection(section) {
	var obj = new getObj(section);
	if (obj.style.display == "none") {
		obj.style.display = "";
	} else {
		obj.style.display = "none";
	}
}


// ---------------------------------------------
// function CloseAllSections closes all sections  
// of 'type', matching the id defined by 'name' 
// ---------------------------------------------
// type is a string                             
//   example: 'div'                             
// name is a regular expression                 
//   example: '^p_' (all id's starting with p_) 
// ---------------------------------------------
// Example: CloseAllSections('div', '^p_') will  
// close all <DIV>-sections which ID starts with 
// 'p_'.                                        
// ---------------------------------------------
function CloseAllSections(type, name) {
	var reg = new RegExp(name);
	aSections=document.getElementsByTagName(type);
	if (aSections) {
		for (i=0; i<aSections.length; i++) {
			if (reg.test(aSections.item(i).id)) {
				CloseSection(aSections.item(i).id);
			}
		} 
	} else {
		CloseSection(aSections.id); 
	}
}

// ---------------------------------------------
// function OpenAllSections shows all sections  
// of 'type', matching the id defined by 'name' 
// ---------------------------------------------
// type is a string                             
//   example: 'div'                             
// name is a regular expression                 
//   example: '^p_' (all id's starting with p_) 
// ---------------------------------------------
// Example: ShowAllSections('div', '^p_') will  
// show all <DIV>-sections which ID starts with 
// 'p_'.                                        
// ---------------------------------------------
function OpenAllSections(type, name) {
	var reg = new RegExp(name);
	aSections=document.getElementsByTagName(type);
	if (aSections) {
		for (i=0; i<aSections.length; i++) {
			if (reg.test(aSections.item(i).id)) {
				OpenSection(aSections.item(i).id);
			}
		} 
	} else {
		OpenSection(aSections.id); 
	}
}
